/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedpipes.container;

import com.refinedmods.refinedpipes.RefinedPipes;
import com.refinedmods.refinedpipes.RefinedPipesContainerMenus;
import com.refinedmods.refinedpipes.container.BaseContainerMenu;
import com.refinedmods.refinedpipes.container.slot.FilterSlot;
import com.refinedmods.refinedpipes.container.slot.FluidFilterSlot;
import com.refinedmods.refinedpipes.inventory.fluid.FluidInventory;
import com.refinedmods.refinedpipes.message.ChangeBlacklistWhitelistMessage;
import com.refinedmods.refinedpipes.message.ChangeExactModeMessage;
import com.refinedmods.refinedpipes.message.ChangeRedstoneModeMessage;
import com.refinedmods.refinedpipes.message.ChangeRoutingModeMessage;
import com.refinedmods.refinedpipes.message.ChangeStackSizeMessage;
import com.refinedmods.refinedpipes.network.pipe.attachment.extractor.BlacklistWhitelist;
import com.refinedmods.refinedpipes.network.pipe.attachment.extractor.ExtractorAttachmentType;
import com.refinedmods.refinedpipes.network.pipe.attachment.extractor.RedstoneMode;
import com.refinedmods.refinedpipes.network.pipe.attachment.extractor.RoutingMode;
import com.refinedmods.refinedpipes.util.FluidUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ExtractorAttachmentContainerMenu
extends BaseContainerMenu {
    private final BlockPos pos;
    private final Direction dir;
    private final ExtractorAttachmentType extractorAttachmentType;
    private final boolean fluidMode;
    private RedstoneMode redstoneMode;
    private BlacklistWhitelist blacklistWhitelist;
    private RoutingMode routingMode;
    private int stackSize;
    private boolean exactMode;

    public ExtractorAttachmentContainerMenu(int windowId, Player player, BlockPos pos, Direction dir, RedstoneMode redstoneMode, BlacklistWhitelist blacklistWhitelist, RoutingMode routingMode, int stackSize, boolean exactMode, ExtractorAttachmentType type, ItemStackHandler itemFilter, FluidInventory fluidFilter, boolean fluidMode) {
        super(RefinedPipesContainerMenus.EXTRACTOR_ATTACHMENT, windowId, player);
        this.addPlayerInventory(8, 111);
        int x = 44;
        int y = 19;
        for (int i = 1; i <= type.getFilterSlots(); ++i) {
            if (fluidMode) {
                this.m_38897_((Slot)new FluidFilterSlot(fluidFilter, i - 1, x, y));
            } else {
                this.m_38897_((Slot)new FilterSlot((IItemHandler)itemFilter, i - 1, x, y));
            }
            if (i % 5 == 0) {
                x = 44;
                y += 18;
                continue;
            }
            x += 18;
        }
        this.pos = pos;
        this.dir = dir;
        this.extractorAttachmentType = type;
        this.fluidMode = fluidMode;
        this.redstoneMode = redstoneMode;
        this.blacklistWhitelist = blacklistWhitelist;
        this.routingMode = routingMode;
        this.stackSize = stackSize;
        this.exactMode = exactMode;
    }

    public boolean isFluidMode() {
        return this.fluidMode;
    }

    public ExtractorAttachmentType getExtractorAttachmentType() {
        return this.extractorAttachmentType;
    }

    public RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    public void setRedstoneMode(RedstoneMode redstoneMode) {
        this.redstoneMode = redstoneMode;
        RefinedPipes.NETWORK.sendToServer(new ChangeRedstoneModeMessage(this.pos, this.dir, redstoneMode));
    }

    public BlacklistWhitelist getBlacklistWhitelist() {
        return this.blacklistWhitelist;
    }

    public void setBlacklistWhitelist(BlacklistWhitelist blacklistWhitelist) {
        this.blacklistWhitelist = blacklistWhitelist;
        RefinedPipes.NETWORK.sendToServer(new ChangeBlacklistWhitelistMessage(this.pos, this.dir, blacklistWhitelist));
    }

    public RoutingMode getRoutingMode() {
        return this.routingMode;
    }

    public void setRoutingMode(RoutingMode routingMode) {
        this.routingMode = routingMode;
        RefinedPipes.NETWORK.sendToServer(new ChangeRoutingModeMessage(this.pos, this.dir, routingMode));
    }

    public int getStackSize() {
        return this.stackSize;
    }

    public void setStackSize(int stackSize) {
        this.stackSize = stackSize;
        RefinedPipes.NETWORK.sendToServer(new ChangeStackSizeMessage(this.pos, this.dir, stackSize));
    }

    public boolean isExactMode() {
        return this.exactMode;
    }

    public void setExactMode(boolean exactMode) {
        this.exactMode = exactMode;
        RefinedPipes.NETWORK.sendToServer(new ChangeExactModeMessage(this.pos, this.dir, exactMode));
    }

    public ItemStack m_7648_(Player player, int index) {
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_() && index < 36) {
            for (int i = 36; i < this.f_38839_.size(); ++i) {
                SlotItemHandler itemSlot;
                Slot filterSlot = (Slot)this.f_38839_.get(i);
                if (filterSlot instanceof FluidFilterSlot) {
                    FluidFilterSlot fluidSlot = (FluidFilterSlot)filterSlot;
                    if (!fluidSlot.getFluidInventory().getFluid(fluidSlot.getSlotIndex()).isEmpty()) continue;
                    FluidStack toInsert = (FluidStack)FluidUtil.getFromStack(slot.m_7993_(), true).getValue();
                    boolean foundExistingFluid = false;
                    for (int j = 0; j < fluidSlot.getFluidInventory().getSlots(); ++j) {
                        if (!fluidSlot.getFluidInventory().getFluid(j).isFluidEqual(toInsert)) continue;
                        foundExistingFluid = true;
                        break;
                    }
                    if (foundExistingFluid) break;
                    fluidSlot.onContainerClicked(slot.m_7993_());
                    break;
                }
                if (!(filterSlot instanceof SlotItemHandler) || (itemSlot = (SlotItemHandler)filterSlot).m_6657_()) continue;
                ItemStack toInsert = ItemHandlerHelper.copyStackWithSize((ItemStack)slot.m_7993_(), (int)1);
                boolean foundExistingItem = false;
                for (int j = 0; j < itemSlot.getItemHandler().getSlots(); ++j) {
                    if (!ItemStack.m_41728_((ItemStack)itemSlot.getItemHandler().getStackInSlot(j), (ItemStack)toInsert)) continue;
                    foundExistingItem = true;
                    break;
                }
                if (foundExistingItem) break;
                itemSlot.m_5852_(toInsert);
                break;
            }
        }
        return ItemStack.f_41583_;
    }
}

